import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../../screens/Utilities/CustomStyleAttribute/dpr";

const { width } = Dimensions.get("screen");
export const singleProductStyle = StyleSheet.create({
    imageContainer: {
        width: width / 2 - dpr(30),
        height: width / 2 - dpr(30),
        backgroundColor: "#FFFFFF",
        marginBottom: dpr(10),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
        position: "relative",
    },
    img: {
        width: width / 2 - dpr(30),
        height: width / 2 - dpr(30),
        borderRadius: 8,
        borderWidth: 1,
        borderColor: "#DFDFDF",
    },
    offerBadge: {
        position: "absolute",
        top: dpr(10),
        left: dpr(10),
        zIndex: 1,
    },
    outStockBadge: {
        backgroundColor: "#F9E8E8",
        paddingHorizontal: dpr(7),
        paddingVertical: 3,
        color: "#C8191C",
        borderRadius: 2,
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        textAlign: "center",
    },
    offBadge: {
        backgroundColor: "#FCCA19",
        color: "#2C2C2C",
        paddingHorizontal: dpr(7),
        paddingVertical: 3,
        borderRadius: 2,
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        marginBottom: dpr(5),
        textAlign: "center",
    },
    featuredBadge: {
        backgroundColor: "#FF6C2E",
        color: "#FFFFFF",
        paddingHorizontal: dpr(7),
        paddingVertical: 3,
        borderRadius: 2,
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        marginBottom: dpr(5),
        textAlign: "center",
    },
    topRatedBadgeCont: {
        backgroundColor: "#00B14F",
        paddingHorizontal: dpr(7),
        paddingVertical: 3,
        borderRadius: 2,
        marginBottom: dpr(5),
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "center",
    },
    topRatedBadge: {
        color: "#FFFFFF",
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(10),
        marginLeft: dpr(2),
    },
});
